#include "scenes.hpp"

const char* const fs_64kb = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "A_ p_ i_ _8 _ _ _6 _4 k_ b_ _ _ D_ e_ m_ o_"
"}";
GLuint fs_64kb_program;
const char* const fs_braincontrol = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "S_ Y_ N_ T_ H_ _ T_ u_ n_ e_ f_ i_ s_ h_ _4 _div B_ r_ a_ i_ n_ c_ o_ n_ t_ r_ o_ l_"
"}";
GLuint fs_braincontrol_program;
const char* const fs_julien = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "C_ O_ D_ E_ _ J_ u_ l_ i_ e_ n_ _ D_ e_ _ L_ o_ o_ r_"
"}";
GLuint fs_julien_program;
const char* const fs_notes_velocity = 
"\n#version 120\n"
"varying vec2 coords;"
"uniform sampler2D notes_velocity;"
"void main()"
"{"
  "float instCount = 11.0;"
  "float nbNotes = 128.0;"
  "vec2 uv = coords*0.5 + vec2(0.5,0.5);"
  "vec2 tex;"
  "tex.x = floor(nbNotes * uv.x)/nbNotes + 0.5/nbNotes;"
  "tex.y = floor(instCount * uv.y)/instCount + 0.5/instCount;"
  "float height = 1.0/instCount;"
  "float y = mod(uv.y,height)/height;"
  "y = y < texture2D(notes_velocity,tex).x ? 1.0: 0.0;"
  "gl_FragColor = vec4(y,y,y,1.0);"
"}";
GLuint fs_notes_velocity_program;
const char* const fs_pierre = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "M_ U_ S_ I_ C_ _ P_ i_ e_ r_ r_ e_ _ D_ e_ _ L_ o_ o_ r_"
"}";
GLuint fs_pierre_program;
const char* const fs_presents = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "E_ N_ I_ B_ _ P_ r_ e_ s_ e_ n_ t_ s_"
"}";
GLuint fs_presents_program;
const char* const fs_pyramid_exterior = 
"float hole_r = 0.;"
"float cur_i = 6.;"
"float pp_y = .9;"
"void globals()"
"{"
  "if (track_time > 118.)"
  "{"
    "hole_r = 3.;"
  "}"
  "else if (track_time > 94.5)"
  "{"
    "hole_r = 1.5 + 1.5*( sin(track_time-58.5) + track_time - 94.5)/(118.-94.5);"
  "}"
  "else if (track_time > 87.5)"
  "{"
    "hole_r = 1.5;"
  "}"
  "else if (track_time > 79.)"
  "{"
    "hole_r = 1.5*(track_time - 79.)/(87.5-79.);"
  "}"
  "if (track_time > 117.5)"
  "{"
    "cur_i = 6.;"
  "}"
  "else if (track_time > 99.)"
  "{"
    "cur_i = 6.;"
  "}"
  "if (track_time > 93. && track_time < 99.)"
  "{"
    "rd_m = 0.3;"
  "}"
  "else if (track_time > 113.)"
  "{"
    "rd_m = 0.4;"
  "}"
  "if (track_time > 120.)"
  "{"
    "pp_y = (-track_time+120.9)*2.;;"
  "}"
"}"
"float pyramid( vec3 p, float h) {"
  "vec3 q=abs(p);"
  "return max(-p.y, (q.x+q.y+q.z-h)/3.0 );"
"}"
"float helice(vec3 p)"
"{"
  "vec3 pr = p;"
  "pr *= -1.;"
  "pr -= vec3(.0,-1.4,.0);"
  "pR(pr.xz,3.*(track_time + sin(track_time-58.5)));"
  "pModPolar(pr.xz,5.);"
  "vec3 prt = pr-vec3(.0,-.25,.0);"
  "float d = fBoxCheap(pr,vec3(0.3));"
  "d = max(d, length(prt) - .4);"
  "d = min(d,pale(prt,0.2,2.));"
  "return d;"
"}"
"float noteV(vec2 p)"
"{"
  "float a = mod(floor(0.5+ (((PI + atan(p.y, p.x))/(2.*PI)) * (64.))),12.) + 32.;"
  "float v = snare*0.4;"
  "for (int i =0; i < 4; i++)"
  "{"
    "v = max(v, getNoteVelocity(a,cur_i));"
    "a = a+12.;"
  "}"
  "return v;"
"}"
"vec2 map(vec3 p)"
"{"
  "p.y += 3.0;"
  "vec2 s = vec2(1.) - 0.3*p.xz;"
  "float b_d = length(p) - hole_r;"
  "if (b_d > 0.) b_d = 0.;"
  "vec2 dmat = vec2(p.y - b_d - 0.3 * terrainSand(s,2), MAT_SAND);"
  "vec3 pp = p; pp.y += pp_y;"
  "vec3 ppp = pp; ppp.y -= 1.2; pR(ppp.xz,0.78); ppp.x += 0.8;"
  "dmat = mmin(dmat,MAT_PYRAMID,max(max(pyramid(pp,2.), -fBoxCheap(pp,vec3(.98,.98,.98))), -fBoxCheap(ppp,vec3(0.5,.12,.1))));"
  "dmat = mmin(dmat, MAT_BLACKMIRROR, helice(pp*2.5));"
  "vec3 c = pp; pModPolar(c.xz,64.); c.x -= 3.; c.y -=0.5+pp_y-0.9;"
  "dmat = mmin(dmat, MAT_MIRROR, fBoxCheap(c,vec3(0.02,1. + 0.2*noteV(pp.xz),0.1)));"
  "return dmat;"
"}"
"vec4 shade(vec3 p, vec3 n, vec3 ro, vec3 rd, float mat)"
"{"
  "float fog = pow(min( length(p-ro)/(dFar*0.5), 1.),200.);"
  "float r = 0.;"
  "vec3 col = vec3(0.);"
  "vec3 ldir1 = normalize(vec3(0., 15.,0.)-p);"
  "vec3 diff1 = vec3(1.,1.,1.) * (max(dot(n,ldir1),0.) );"
  "float da = 1.;"
  "float ao = 1.;"
  "ao = ambientOcclusion(p,n);"
  "if (mat==MAT_MIRROR)"
  "{"
    "r = 1.;"
    "col= vec3(0.7, 0.6, 0.3);"
    "da = 3. + 5.*noteV(p.xz);"
  "}"
  "else if (mat == MAT_PYRAMID)"
  "{"
    "col= vec3(1.,1.,0.5);"
  "}"
  "else if (mat== MAT_SAND)"
  "{"
    "col= mix( vec3(0.3, 0.2, 0.0), vec3(0.7, 0.6, 0.3), n.y );"
  "}"
  "else if (mat== MAT_BLACKMIRROR)"
  "{"
    "r = 1.;"
    "col= vec3(1.,1.,0.5);"
    "da = .3;"
  "}"
  "col = col * (diff1) * ao *da;"
  "vec3 skyCol = vec3(.7,0.7,1.);"
  "col = mix(col, skyCol, fog );"
  "return vec4(col,r);"
"}";
GLuint fs_pyramid_exterior_program;
const char* const fs_pyramid_interior = 
"vec3 lpos1 = vec3(0.,-1.,5.);"
"vec3 lpos2 = vec3(2.,-0.5,2.);"
"vec3 lpos3 = vec3(-2.,-.5,-2.);"
"float hel_l = 0.;"
"float rot_d;"
"float ball_r;"
"float pale_l = 0.;"
"float rot_h = PI/2.;"
"float rotate_sand_time=0.;"
"void globals()"
"{"
  "if (track_time < 41.)"
  "{"
    "rot_d = 1. + 3. * sin(sequence_time);"
    "ball_r = 1.;"
  "}"
  "else if (track_time < 48.)"
  "{"
    "float k = (track_time - 41.)/(48.-41.);"
    "rot_d = 4. * k;"
    "ball_r = .7 - 0.35 * k;"
  "}"
  "else if (track_time < 54.)"
  "{"
    "float k = (track_time - 48.)/(54.-48.);"
    "pale_l = 0.35+ 1.65 * k;"
    "rot_d = 4.;"
    "ball_r = .35;"
  "}"
  "else"
  "{"
    "pale_l = 2.;"
    "rot_d = 4.;"
    "ball_r = .35;"
  "}"
  "if (track_time > 58.5)"
  "{"
    "rot_h = 3.*(track_time + sin(track_time-58.5));"
  "}"
"}"
"vec2 map(vec3 p)"
"{"
  "vec3 pr = p;"
  "pr -= vec3(.0,-1.,.0);"
  "pR(pr.xz,rot_h);"
  "pModPolar(pr.xz,1. + rot_d);"
  "vec3 prt = pr-vec3(.0,-.25,.0);"
  "vec2 dmat = vec2(fBoxCheap(pr,vec3(0.3)),MAT_MIRROR);"
  "if ( track_time > 41.)"
  "{"
    "dmat.x = max(dmat.x, length(prt) - ball_r);"
  "}"
  "if ( track_time > 48.)"
  "{"
    "dmat = mmin(dmat,MAT_MIRROR,pale(prt,0.2,pale_l));"
  "}"
  "dmat = mmin(dmat,MAT_PYRAMID,fPlane(p,vec3(-0.5,-0.5,0.),2.));"
  "dmat = mmin(dmat,MAT_PYRAMID,fPlane(p,vec3(0.5,-0.5,0.),2.));"
  "dmat = mmin(dmat,MAT_PYRAMID,max(fPlane(p,vec3(0.,-0.5,-0.5),2.),-fBoxCheap(p-vec3(0.,-1.,5.),vec3(.5,1.,1.))));"
  "dmat = mmin(dmat,MAT_PYRAMID,fPlane(p,vec3(0.,-0.5,0.5),2.));"
  "dmat = mmin(dmat,MAT_BLACKMIRROR,"
  "fOpUnionStairs("
  "fBoxCheap(p - vec3(.0,-1.5,.0),vec3(1.,0.05,.8)),"
  "fBoxCheap(p - vec3(.0,-1.8,.0),vec3(0.8,0.15,.5)),.2,3.));"
  "float fake_d = fPlane(p,vec3(0.,1.,0.),2.);"
  "vec2 s = 0.8*p.xz;pR(s,rotate_sand_time);"
  "dmat = fmin(dmat,MAT_SAND,fake_d, p.y + 2.0 + 0.2 * terrainSand(s,2));"
  "return dmat;"
"}"
"vec4 shade(vec3 p, vec3 n, vec3 ro, vec3 rd, float mat)"
"{"
  "float fog = pow(min( length(p-ro)/(dFar*0.9), 1.),200.);"
  "float r = 0.;"
  "vec3 col = vec3(0.);"
  "vec3 ldir1 = normalize(lpos1-p);"
  "vec3 ldir2 = normalize(lpos2-p);"
  "vec3 ldir3 = normalize(lpos3-p);"
  "float latt1 = pow( length(lpos1.xy-p.xy)*(.7-snare*.3), 1.5 );"
  "float latt2 = pow( length(lpos2-p)*.75, 1. );"
  "float latt3 = pow( length(lpos3-p)*.75, 2.5 );"
  "vec3 diff1 = vec3(1.,1.,1.) * (max(dot(n,ldir1),0.) ) / latt1;"
  "vec3 diff2 = vec3(1.,1.,1.) * (max(dot(n,ldir2),0.) ) / latt2;"
  "vec3 diff3 = vec3(1.,1.,1.) * (max(dot(n,ldir3),0.) ) / latt3;"
  "float da = 1.;"
  "float ao = 1.;"
  "if (mat==MAT_MIRROR)"
  "{"
    "r = 1.;"
    "col= vec3(0.8);"
    "da = 0.5;"
  "}"
  "else if (mat == MAT_PYRAMID)"
  "{"
    "col= vec3(1.,1.,0.5);"
    "ao = ambientOcclusion(p,n);"
  "}"
  "else if (mat== MAT_SAND)"
  "{"
    "col= mix( vec3(0.3, 0.2, 0.0), vec3(0.7, 0.6, 0.3), n.y );"
  "}"
  "else if (mat== MAT_BLACKMIRROR)"
  "{"
    "col= vec3(0.1,0.1,0.1);"
    "r = 1.;"
    "da = .1;"
  "}"
  "col = col * (diff1 + diff2 + diff3) * ao *da;"
  "vec3 skyCol = vec3(1.);"
  "col = mix(col, skyCol, fog );"
  "return vec4(col,r);"
"}";
GLuint fs_pyramid_interior_program;
const char* const fs_title = 
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital)"
"{"
  "D_ a_ s_ _ _ S_ a_ n_ s_ e_ f_ f_ o_ r_ t_ s_ e_ u_ r_"
"}";
GLuint fs_title_program;
const char* const scenes_src[SCENES_COUNT] = {
  fs_64kb,
  fs_braincontrol,
  fs_julien,
  fs_notes_velocity,
  fs_pierre,
  fs_presents,
  fs_pyramid_exterior,
  fs_pyramid_interior,
  fs_title
};
const char* const scenes_framework_src[SCENES_COUNT] = {
  fs_font,
  fs_font,
  fs_font,
  0 ,
  fs_font,
  fs_font,
  fs_raymarcher,
  fs_raymarcher,
  fs_font
};
GLuint* const scenes_programs[SCENES_COUNT] = {
  &fs_64kb_program,
  &fs_braincontrol_program,
  &fs_julien_program,
  &fs_notes_velocity_program,
  &fs_pierre_program,
  &fs_presents_program,
  &fs_pyramid_exterior_program,
  &fs_pyramid_interior_program,
  &fs_title_program
};
